<?php 
    include "../../conn.php";
    include "../../functions2.php";
    
    header('Content-Type: application/json; charset=utf-8');
    header('Strict-Transport-Security: max-age=31536000');
    header('Access-Control-Allow-Headers: Origin, X-Requested-With, Content-Type, Accept, Authorization');
    header('Access-Control-Allow-Credentials: true');
    $origin = isset($_SERVER['HTTP_ORIGIN']) ? $_SERVER['HTTP_ORIGIN'] : '';
    header('Access-Control-Allow-Origin: ' . $origin);
    header('vary: Origin');
    
    date_default_timezone_set("Asia/Kolkata");
    $shnunc = date("Y-m-d H:i:s");
    $res = [
        'code' => 11,
        'msg' => 'Method not allowed',
        'msgCode' => 12,
        'serviceNowTime' => $shnunc,
    ];
    $shonubody = file_get_contents("php://input");
    $shonupost = json_decode($shonubody, true);
    
    if ($_SERVER['REQUEST_METHOD'] != 'GET') {
        if (isset($shonupost['language']) && isset($shonupost['random']) && isset($shonupost['signature']) && isset($shonupost['timestamp'])) {
            $language = htmlspecialchars(mysqli_real_escape_string($conn, $shonupost['language']));
            $random = htmlspecialchars(mysqli_real_escape_string($conn, $shonupost['random']));
            $signature = htmlspecialchars(mysqli_real_escape_string($conn, $shonupost['signature']));
            $shonustr = '{"language":'.$language.',"random":"'.$random.'"}';
            $shonusign = strtoupper(md5($shonustr));
            if($shonusign == $signature){
                $bearer = explode(" ", $_SERVER['HTTP_AUTHORIZATION']);
                $author = $bearer[1];				
                $is_jwt_valid = is_jwt_valid($author);
                $data_auth = json_decode($is_jwt_valid, 1);
                if($data_auth['status'] === 'Success') {
                    $sesquery = "SELECT codechorkamukala FROM shonu_subjects WHERE akshinak = '$author'";
                    $sesresult = $conn->query($sesquery);
                    
                    $sesnum = mysqli_num_rows($sesresult);
                    if ($sesresult->num_rows == 1) {
                        $user = $sesresult->fetch_assoc();
                        $userCode = $user['codechorkamukala']; // Fetch userCode from codechorkamukala column
                    
                        // Fetch balance from API vendor
                        $apiResponse = fetchVendorBalance($userCode);
                    
                        if ($apiResponse !== null) {
                            $apiData = json_decode($apiResponse, true);
                            if (isset($apiData['success']) && $apiData['success'] && isset($apiData['message'])) {
                                $tbChessBalance = (float)$apiData['message'];
                            } else {
                                $tbChessBalance = 0; // Default to 0 if API response is invalid
                            }
                        } else {
                            $tbChessBalance = 0; // Default to 0 if API call fails
                        }
                    
                        $data = [
                            "vendorCode" => "ARGame",
                            "balance" => $tbChessBalance
                        ];
                    
                        $res['data'] = $data;
                        $res['code'] = 0;
                        $res['msg'] = 'Succeed';
                        $res['msgCode'] = 0;
                        $res['serviceNowTime'] = $shnunc;
                    
                        http_response_code(200);
                        echo json_encode($res);
                    } else {
                        $res['code'] = 4;
                        $res['msg'] = 'No operation permission';
                        $res['msgCode'] = 2;
                        http_response_code(401);
                        echo json_encode($res);
                    }
                }
                else{					
                    $res['code'] = 4;
                    $res['msg'] = 'No operation permission';
                    $res['msgCode'] = 2;
                    http_response_code(401);
                    echo json_encode($res);					
                }
            }
            else{
                $res['code'] = 5;
                $res['msg'] = 'Wrong signature';
                $res['msgCode'] = 3;
                http_response_code(200);
                echo json_encode($res);				
            }
        }
        else{
            $res['code'] = 7;
            $res['msg'] = 'Param is Invalid';
            $res['msgCode'] = 6;
            http_response_code(200);
            echo json_encode($res);			
        }		
    } else {		
        http_response_code(405);
        echo json_encode($res);
    }

    /**
     * Fetch user balance from the API vendor.
     *
     * @param string $userCode
     * @return string|null
     */
    function fetchVendorBalance($userCode)
    {
        try {
            $authToken = getAuthToken();
            $apiUrl = "https://dcyqv8f2id.com/api/v2/user/balance"; // Replace with actual API URL

            $postData = [
                'userCode' => $userCode
            ];

            $ch = curl_init($apiUrl);
            curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
            curl_setopt($ch, CURLOPT_POST, true);
            curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($postData));
            curl_setopt($ch, CURLOPT_HTTPHEADER, [
                'Authorization: Bearer ' . $authToken,
                'Content-Type: application/json'
            ]);
            curl_setopt($ch, CURLOPT_IPRESOLVE, CURL_IPRESOLVE_V4);
            $response = curl_exec($ch);
            $httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
            curl_close($ch);

            if ($httpCode == 200) {
                return $response; // Return the raw response
            }
        } catch (Exception $e) {
            error_log('Error fetching vendor balance: ' . $e->getMessage());
        }

        return null;
    }

    /**
     * Fetch authentication token.
     *
     * @return string
     */
    function getAuthToken()
    {
        try {
            $authUrl = "https://dcyqv8f2id.com/api/v2/auth/createtoken"; // Replace with actual auth URL
            $postData = [
                'clientId' => 'top52-inr2',
                'clientSecret' => 'OhNqb9vH4UfLzPhLo4XQefH5BpGcfgpD'
            ];

        	$ch = curl_init($authUrl);
            curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
            curl_setopt($ch, CURLOPT_POST, true);
            curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($postData));
            curl_setopt($ch, CURLOPT_HTTPHEADER, [
                'Content-Type: application/json',
                'Accept: application/json'
            ]);
            curl_setopt($ch, CURLOPT_IPRESOLVE, CURL_IPRESOLVE_V4);
            $response = curl_exec($ch);
            $httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
            curl_close($ch);

            if ($httpCode == 200) {
                $data = json_decode($response, true);
                if (isset($data['token'])) {
                    return $data['token'];
                }
            }
        } catch (Exception $e) {
            error_log('Error fetching auth token: ' . $e->getMessage());
        }

        throw new Exception('Failed to fetch auth token');
    }
?>